# Rule 11.6.1 All variables should be initialized

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Amplification
All variables should either be explicitly or implicitly initialized.

Apart from the following, all variables should be explicitly initialized with an associated initializer in
their definition:
1. Variables of `class` type, or
2. Function parameters (which are initialized with the corresponding argument value), or
3. Variables with static storage duration (which are *zero-initialized* by default).

## Rationale
Having several states within a program increases the risk of defects being introduced. Each variable
that is first uninitialized, then set to a value creates two program states. It is therefore better to initialize
the variable directly to a value that is to be used. The intent of this rule is not that each variable is
initialized with some value, but that it is initialized with its real value; the one that will be used when
the variable is next read.

In order to achieve this, the variable definition can be delayed until the “right” value is available. This
naturally leads to reducing the variable's scope, reducing the risk of the variable being used
inappropriately. An immediately evaluated lambda can be used to compute a value when a variable's
initialization is more complex.

In many cases, initializing the variable within its definition allows it to be a constant definition.

*Note:* there are many ways to explicitly initialize a variable. When possible, the list-initialization syntax
(with curly braces) should be used as it does not suffer from the issues that arise from the use of other
syntactic forms (e.g. narrowing or declaring a function while trying to define a variable, also known as
“the most vexing parse”).

## Example
```cpp
void f( bool cond )
{
 int32_t i; // Non-compliant

 if ( cond ) { i = 42; }
 else { i = -1; }

 int32_t j = cond ? 42 : -1; // Compliant
 int32_t k = [&]() // Compliant
 {
 if ( cond ) { return 42; }
 else { return -1; }
 }();

 string s; // Compliant - default-initialized
}

int32_t g; // Compliant - static initialization applies

void f()
{
 thread_local int32_t i; // Compliant - static initialization applies
}
```

## See also
Rule 15.1.4

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
