# Rule 19.3.2 A macro parameter immediately following a # operator shall not be immediately followed by a ## operator

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Rationale
The order of evaluation associated with multiple `#`, multiple `##` or a mix of `#` and `##` preprocessor
operators is *unspecified*. The use of `#` and `##` is discouraged by Rule 19.3.1. In particular, the result of
a `#` operator is a string literal and it is unlikely that pasting this to any other preprocessing token will
result in a valid token.

## Example
```cpp
#define A( x ) #x // Compliant
#define B( x, y ) x ## y // Compliant
#define C( x, y ) x ## #y // Compliant
#define D( x, y ) #x ## y // Non-compliant
```

## See also
Rule 19.3.1, Rule 19.3.3

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
