# Rule 19.3.5 Tokens that look like a preprocessing directive shall not occur within a macro argument

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Rationale
A macro argument containing sequences of tokens that would otherwise act as preprocessing
directives results in *undefined behaviour*.

## Example
```cpp
#define M(A) printf ( #A )

int main()
{
 M(
#ifdef SW // Non-compliant
 "Message 1"
#else // Non-compliant
 "Message 2"
#endif // Non-compliant
 );
}
```

The above could print:
`#ifdef SW "Message 1" #else "Message 2" #endif`
or it could print:
`Message 2`
or it could exhibit some other behaviour.

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
