# Rule 21.10.2 The standard header file <csetjmp> shall not be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
In addition, none of the facilities that are specified as being provided by `<csetjmp>` shall be used.

*Note:* use of `<setjmp.h>` and the facilities it provides are also prohibited by this rule.

## Rationale
The use of `setjmp` and `longjmp` allow the normal function return mechanisms to be bypassed.
Their use may result in *undefined* and *unspecified behaviour*. For example, it is *undefined behaviour* if
`longjmp` results in the omission of non-trivial object destruction.

Safety standards, such as IEC 61508 [11] (Part 3, Table B.9) or ISO 26262 [9] (Part 6, Table 6),
encourage the use of the “single-entry single-exit” principle as part of the “modular approach”.
Unstructured languages, such as assembly, allow jumps between arbitrary points in a program,
violating this principle. C++, with its concept of functions and the corresponding calling mechanism,
enforces the “single-entry single-exit” principle through its language definition — for example, multiple
`return` statements within a function all return to the call site.

*Note:* the C++ Standard states that aspects of the behaviour associated with these facilities are defined
in the related version of ISO 9899 [6].

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
