# Rule 21.6.4 If a project defines either a sized or unsized version of a global operator delete, then both shall be defined

## Category
Required

## Analysis
Decidable, System

## Rationale
Within a *delete-expression*, the C++ Standard does not always specify if the sized or the unsized version
of the deallocation function will be selected. Therefore, both versions should be provided, and have
the same effect, to ensure that the behaviour is well-defined.

## Example
The following example is compliant as sized and unsized versions of `operator delete` are provided:

```cpp
void operator delete( void * ptr ) noexcept
{
 std::free( ptr );
}

void operator delete( void * ptr, std::size_t size ) noexcept
{
 delete( ptr );
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
