# Rule 21.6.5 A pointer to an incomplete class type shall not be deleted

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Rationale
An incomplete `class` type is a forward declared `class` type for which the compiler has not yet seen
a complete definition.

Deleting a pointer to an incomplete `class` type results in *undefined behaviour* when the complete
`class` type has a non-trivial destructor or a deallocation function.

This rule prohibits deletion of a pointer to an incomplete `class` type even when it is a trivially destructible
class without a deallocation function. This restriction defends against a non-trivial destructor or a
deallocation function being added during development.

## Example
The following examples violate Rule 21.6.2.

```cpp
class Bad
{
 class Impl;
 Impl * pImpl;
public:
 ~Bad()
 {
 delete pImpl; // Non-compliant - at the point of deletion, pImpl points
 // to an object of incomplete class type.
 }
};

// Header file
class Good
{
 class Impl;
 Impl * pImpl;
public:
 ~Good();
};

// Implementation file
class Good::Impl
{
};

// Good::Impl is a complete type now
Good::~Good()
{
 delete pImpl; // Compliant - at the point of deletion, pImpl points to
 // a complete class type.
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
