# Rule 5.13.3 Octal constants shall not be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Rationale
Any integer constant beginning with a `0` (zero) is an octal constant. Because of this, a zero-prefixed
constant that is intended to be a decimal number may be interpreted as an octal number, contrary
to developer expectations.

Note: this rule does not apply to octal escape sequences because the use of a leading `\` character
means that there is less scope for confusion.

## Exception
The integer constant `0` (written as a single numeric digit) is an octal constant, but its use is permitted
as an exception to this rule.

## Example
```cpp
code[ 1 ] = 109; // Compliant - decimal 109
code[ 2 ] = 100; // Compliant - decimal 100
code[ 3 ] = 052; // Non-compliant - equivalent to decimal 42, not 52
code[ 4 ] = 071; // Non-compliant - equivalent to decimal 57, not 71
code[ 5 ] = 0; // Compliant by exception
code[ 6 ] = 000; // Non-compliant - exception does not apply
code[ 7 ] = '\123'; // Rule does not apply
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
