# Rule 8.9.1 The built-in relational operators `>`, `>=`, `<` and `<=` shall not be applied to objects of pointer type, except where they point to elements of the same array

## Category
Required

## Analysis
Undecidable, System

## Amplification
Uses of `std::less`, `std::less_equal`, `std::greater`, `std::greater_equal` are permitted as
specializations for any pointer type yield a strict total order.

Notes:
1.  A pointer to one beyond the last element of an array is considered to point to an element of that
    array.
2.  A pointer to an object that is not an array is treated as if it were a pointer to the first element of
    an array with a single element.

## Rationale
Attempting to make comparisons between unrelated pointers may result in surprising or *unspecified*
*behaviour*.

## Example
```cpp
void f1()
{
  int32_t a1[ 10 ];
  int32_t a2[ 10 ];
  int32_t * p1 = a1;

  if ( p1 < a1 ) {} // Compliant
  if ( p1 < std::end( a1 ) ) {} // Compliant - right operand is one beyond
  if ( p1 < a2 ) {} // Non-compliant
  if ( std::less<>{}( p1, a2 ) ) { } // Compliant
}

struct S
{
  int32_t m1;
  int32_t m2;
};

void f2()
{
  S x { };
  if ( &x.m1 <= &x.m2 ) {} // Non-compliant - m1 and m2 are not array elements
}
```

## See also
Rule 4.1.3

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
