# Rule 15.1 The *goto* statement should not be used

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Rationale
Unconstrained use of *goto* can lead to programs that are unstructured and extremely difficult to
understand.

In some cases a total ban on *goto* requires the introduction of flags to ensure correct control flow,
and it is possible that these flags may themselves be less transparent than the *goto* they replace.
Therefore, if this rule is not followed, the restricted use of *goto* is allowed where that use follows the
guidance in Rule 15.2 and Rule 15.3.

## See also
Rule 9.1, Rule 15.2, Rule 15.3, Rule 15.4

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
