# Rule 19.2 The `union` keyword should not be used

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Rationale
A union member can be written and the same member can then be read back in a well-defined
manner.

However, if a union member is written and then a different union member is read back, the behaviour
depends on the relative sizes of the members:
* If the member read is wider than the member written then the value is unspecified;
* Otherwise, the value is implementation-defined.

The Standard permits the bytes of a union member to be accessed by means of another member
whose type is array of `unsigned char`. However, since it is possible to access bytes with unspecified
values, unions should not be used.

If this rule is not followed, the kinds of behaviour that need to be determined are:
* Padding — how much padding is inserted at the end of the union;
* Alignment — how are members of any structures within the union aligned;
* Endianness — is the most significant byte of a word stored at the lowest or highest memory
address;
* Bit-order — how are bits numbered within bytes and how are bits allocated to bit fields.

## Example
In this non-compliant example, a 16-bit value is stored into a union but a 32-bit value is read back
resulting in an unspecified value being returned.
```c
uint32_t zext ( uint16_t s )
{
 union
 {
 uint32_t ul;
 uint16_t us;
 } tmp;
 tmp.us = s;
 return tmp.ul; /* unspecified value */
}
```

## See also
Rule 19.1

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
