# Rule 20.1 `#include` directives should only be preceded by preprocessor directives or comments

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Amplification
The rule shall be applied to the contents of a file before preprocessing occurs.

## Rationale
To aid code readability, all the `#include` directives in a particular code file should be grouped together
near the top of the file.

Additionally, using `#include` to include a standard header file within a declaration or definition, or using
part of The Standard Library before the inclusion of the related standard header file leads to undefined
behaviour.

## Example
```c
/* f.h */
xyz = 0;
/* f.c */
int16_t
#include "f.h" /* Non-compliant */
/* f1.c */
#define F1_MACRO
#include "f1.h" /* Compliant */
#include "f2.h" /* Compliant */
int32_t i = 0;
#include "f3.h" /* Non-compliant */
```

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
