# Rule 22.6 The value of a pointer to a `FILE` shall not be used after the associated stream has been closed

## Category
Mandatory

## Analysis
Undecidable, System

## Applies to
C90, C99

## Rationale
The Standard states that the value of a `FILE` pointer is indeterminate after a close operation on a
stream.

## Example
```c
#include <stdio.h>
void fn ( void )
{
 FILE *fp;
 void *p;
 fp = fopen ( "tmp", "w" );
 if ( fp == NULL )
 {
 error_action ( );
 }
 fclose ( fp );
 fprintf ( fp, "?" ); /* Non-compliant */
 p = fp; /* Non-compliant */
}
```

## See also
Dir 4.13, Rule 21.6

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
