# Rule 7.2 A “u” or “U” suffix shall be applied to all integer constants that are represented in an unsigned type

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Amplification
This rule applies to:
* Integer constants that appear in the controlling expressions of #if and #elif preprocessing directives;
* Any other integer constants that exist after preprocessing.

Note: during preprocessing, the type of an integer constant is determined in the same manner as after preprocessing except that:
* All signed integer types behave as if they were *long* (C90) or *intmax_t* (C99);
* All unsigned integer types behave as if they were *unsigned long* (C90) or *uintmax_t* (C99).

## Rationale
The type of an integer constant is a potential source of confusion, because it is dependent on a complex combination of factors including:
* The magnitude of the constant;
* The implemented sizes of the integer types;
* The presence of any suffixes;
* The number base in which the value is expressed (i.e. decimal, octal or hexadecimal).

For example, the integer constant 40000 is of type *signed int* in a 32-bit environment but of type *signed long* in a 16-bit environment. The value 0x8000 is of type *unsigned int* in a 16-bit environment, but of type *signed int* in a 32-bit environment.

Note:
* Any value with a “U” suffix is of unsigned type;
* An unsuffixed decimal value less than 2^31 is of signed type.

But:
* An unsuffixed hexadecimal value greater than or equal to 2^15 may be of signed or unsigned type;
* For C90, an unsuffixed decimal value greater than or equal to 2^31 may be of signed or unsigned type.

Signedness of constants should be explicit. If a constant is of an unsigned type, applying a “U” suffix makes it clear that the programmer understands that the constant is unsigned.

Note: this rule does not depend on the context in which a constant is used; promotion and other conversions that may be applied to the constant are not relevant in determining compliance with this rule.

## Example
The following example assumes a machine with a 16-bit *int* type and a 32-bit *long* type. It shows the type of each integer constant determined in accordance with The Standard. The integer constant 0x8000 is non-compliant because it has an unsigned type but does not have a “U” suffix.

| Constant | Type | Compliance |
| --- | --- | --- |
| 32767 | *signed int* | Compliant |
| 0x7fff | *signed int* | Compliant |
| 32768 | *signed long* | Compliant |
| 32768u | *unsigned int* | Compliant |
| 0x8000 | *unsigned int* | Non-compliant |
| 0x8000u | *unsigned int* | Compliant |

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
