# Rule 8.3 All declarations of an object or function shall use the same names and type qualifiers

## Category
Required

## Analysis
Decidable, System

## Applies to
C90, C99

## Amplification
Storage class specifiers are not included within the scope of this rule.

## Rationale
Using types and qualifiers consistently across declarations of the same object or function encourages stronger typing.

Specifying parameter names in function prototypes allows the function definition to be checked for interface consistency with its declarations.

## Exception
Compatible versions of the same basic type may be used interchangeably. For example, *int*, *signed* and *signed int* are all equivalent.

## Example
```c
extern void f ( signed int );
       void f ( int );        /* Compliant - Exception */

extern void g ( int * const );
       void g ( int * );      /* Non-compliant - type qualifiers */
```

Note: all the above are not compliant with Dir 4.6.

```c
extern int16_t func ( int16_t num, int16_t den );

/* Non-compliant - parameter names do not match */
int16_t func ( int16_t den, int16_t num )
{
  return num / den;
}
```

In this example the definition of `area` uses a different type name for the parameter `h` from that used in the declaration. This does not comply with the rule even though `width_t` and `height_t` are the same basic type.

```c
typedef uint16_t width_t;
typedef uint16_t height_t;
typedef uint32_t area_t;

extern area_t area ( width_t w, height_t h );

area_t area ( width_t w, width_t h )
{
  return ( area_t ) w * h;
}
```

This rule does not require that a function pointer declaration use the same names as a function declaration. The following example is therefore compliant.

```c
extern void f1 ( int16_t x );
extern void f2 ( int16_t y );

void f ( bool_t b )
{
  void ( *fp1 ) ( int16_t z ) = b ? f1 : f2;
}
```

## See also
Rule 8.4

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
