# Rule 11.6 A cast shall not be performed between pointer to void and an arithmetic type
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Rationale
Conversion of an integer into a pointer to *void* results in behaviour that is implementation-defined.
Conversion of a pointer to *void* into an integer may produce a value that cannot be represented in the chosen integer type resulting in undefined behaviour.
Conversion between any non-integer arithmetic type and pointer to *void* is undefined.
## Exception
An *integer constant expression* with value 0 may be cast into pointer to *void*.
## Example
```c
void *p;
uint32_t u;

/* Non-compliant - implementation-defined */
p = ( void * ) 0x1234u;

/* Non-compliant - undefined */
p = ( void * ) 1024.0f;

/* Non-compliant - implementation-defined */
u = ( uint32_t ) p;
```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
