# Rule 13.5 The right hand operand of a logical && or || operator shall not contain persistent side effects
## Category
Required
## Analysis
Undecidable, System
## Applies to
C90, C99, C11
## Rationale
The evaluation of the right-hand operand of the `&&` and `||` operators is conditional on the value of the left-hand operand. If the right-hand operand contains *side effects* then those *side effects* may or may not occur which may be contrary to programmer expectations.
If evaluation of the right-hand operand would produce *side effects* which are not *persistent* at the point in the program where the expression occurs then it does not matter whether the right-hand operand is evaluated or not.
The term *persistent side effect* is defined in Appendix J.
## Example
```c
uint16_t f ( uint16_t y )
{
 /* These side effects are not persistent as seen by the caller */
 uint16_t temp = y;
 temp = y + 0x8080U;
 return temp;
}

uint16_t h ( uint16_t y )
{
 static uint16_t temp = 0;
 /* This side effect is persistent */
 temp = y + temp;
 return temp;
}

void g ( void )
{
 /* Compliant - f ( ) has no persistent side effects */
 if ( ishigh && ( a == f ( x ) ) )
 {
 }
 /* Non-compliant - h ( ) has a persistent side effect */
 if ( ishigh && ( a == h ( x ) ) )
 {
 }
}

volatile uint16_t v;
 uint16_t x;

/* Non-compliant - access to volatile v is persistent */
if ( ( x == 0u ) || ( v == 1u ) )
{
}

/* Non-compliant if fp points to a function with persistent side effects */
( fp != NULL ) && ( *fp ) ( 0 );
```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
