# Rule 23.2 A generic selection that is not expanded from a macro shall not contain potential side effects in the controlling expression

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C11

## Amplification
If the controlling expression of a generic selection is not expanded from a macro argument, it shall
not appear to contain any *side effects*.

A function call is considered to be a *side effect* for the purposes of this rule.

## Rationale
The controlling expression of a generic selection is never evaluated. It is only used for its type, and
usually has to be repeated in order to be combined with the result value in some way.

If an expression is specified which syntactically contains a side effect, that effect will not be applied,
even if the expression has a type that would cause it to be evaluated by `sizeof`, such as a VLA.

## Example
```c
#ifdef BIG
typedef int64_t STATE;
#else
typedef int16_t STATE;
#endif

STATE shared_state;

/* Compliant */
_Static_assert ( _Generic ( shared_state
 , int32_t: 0
 , default: 1 )
 , "error on wrong type");
```

This example is non-compliant because the apparent side effect modifying `shared_state` is not
evaluated by the controlling expression:
```c
/* Non-compliant */
_Static_assert ( _Generic ( ++shared_state
 , int32_t: 0
 , default: 1)
 , "error on wrong type");
```

## See also
Rule 13.6, Rule 23.1, Rule 23.7

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
