# Rule 5.1 External identifiers shall be distinct

## Category

Required

## Analysis

Decidable, System

## Applies to

C90, C99, C11

## Amplification

This rule requires that different external identifiers be distinct within the limits imposed by the implementation. The definition of distinct depends on the implementation and on the edition of the C Standard that is being used:
* In C90 the minimum requirement is that the first 6 characters of external identifiers are significant but their case is not required to be significant;
* In C99 and later the minimum requirement is that the first 31 characters of external identifiers are significant, with each universal character or corresponding extended source character occupying between 6 and 10 characters.

In practice, many implementations provide greater limits. For example it is common for external identifiers in C90 to be case-sensitive and for at least the first 31 characters to be significant. 

## Rationale

If two identifiers differ only in non-significant characters, the behaviour is undefined.

If portability is a concern, it would be prudent to apply this rule using the minimum limits specified in the C Standard.

Long identifiers may impair the readability of code. While many automatic code generation systems produce long identifiers, there is a good argument for keeping identifier lengths well below this limit.

Note: In C99 and later, if an extended source character appears in an external identifier and that character does not have a corresponding universal character, the C Standard does not specify how many characters it occupies. 

## Example

In the following example, the definitions all occur in the same translation unit. The implementation in question supports 31 significant case-sensitive characters in external identifiers.

```c
/* 1234567890123456789012345678901********* Characters */
int32_t engine_exhaust_gas_temperature_raw;
int32_t engine_exhaust_gas_temperature_scaled; /* Non-compliant */

/* 1234567890123456789012345678901********* Characters */
int32_t engine_exhaust_gas_temp_raw;
int32_t engine_exhaust_gas_temp_scaled; /* Compliant */

```

In the following non-compliant example, the implementation supports 6 significant case-insensitive characters in external identifiers. The identifiers in the two translation units are different but are not distinct in their significant characters.

```c
/* file1.c */
int32_t abc = 0;

/* file2.c */
int32_t ABC = 0;

```

## See also

Dir 1.1, Rule 5.2, Rule 5.4, Rule 5.5

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
