# Rule 8.9 An object should be declared at block scope if its identifier only appears in a single function

## Category

Advisory

## Analysis

Decidable, System

## Applies to

C90, C99, C11

## Rationale

Declaring an object at block scope reduces the possibility that the object might be accessed inadvertently and makes clear the intention that it should not be accessed elsewhere. Within a function, whether objects are declared at the outermost or innermost block is largely a matter of style.

It is recognized that there are situations in which it may not be possible to comply with this rule. For example, an object with static storage duration declared at block scope cannot be accessed directly from outside the block. This makes it impossible to set up and check the results of unit test cases without using indirect accesses to the object. In this kind of situation, some projects may prefer not to apply this rule. 

## Example

In this compliant example, `i` is declared at block scope because it is a loop counter. There is no need for other functions in the same file to use the same object for any other purpose.

```c
void func (void)
{
    int32_t i;
    for ( i = 0; i < N; ++i )
    {
    }
}

```

In this compliant example, the function `count` keeps track of the number of times it has been called and returns that number. No other function needs to know the details of the implementation of `count` so the call counter is declared with block scope.

```c
uint32_t count (void)
{
    static uint32_t call_count = 0;
    ++call_count;
    return call_count;
}

```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
