# Dir 4.4 Sections of code should not be "commented out" 

## Category

Advisory 

## Applies to

C90, C99, C11 

## Amplification

This rule applies to both `//` and `/*` `*/` styles of comment. 

## Rationale

Where it is required for sections of source code not to be compiled then this should be achieved by use of conditional compilation (e.g. `#if` or `#ifdef` constructs with a comment). Using start and end comment markers for this purpose is dangerous because C does not support nested comments, and any comments already existing in the section of code would change the effect. 

## See also

Rule 3.1, Rule 3.2 

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
