# Rule 21.13 Any value passed to a function in `<ctype.h>` shall be representable as an *unsigned char* or be the value EOF

## Category
Mandatory

## Analysis
Undecidable, System

## Applies to
C90, C99, C11

## Rationale
The relevant functions from `<ctype.h>` are defined to take an *int* argument where the expected value is either in the range of an *unsigned char* or is a negative value equivalent to EOF. The use of any other values results in *undefined behaviour*.

## Example
*Note:* The *int* casts in the following example are required to comply with Rule 10.3.
```c
bool_t f ( uint8_t a )
{
  return ( isdigit ( ( int32_t ) a   )    /* Compliant     */
        && isalpha ( ( int32_t ) 'b' )    /* Compliant     */
        && islower (             EOF )    /* Compliant     */
        && isalpha (             256 ) ); /* Non-compliant */
}
```

## See also
Rule 10.3

---

Copyright The MISRA Consortium Limited © [Date - March 2025].