# Rule 5.6 A typedef name shall be a unique identifier

## Category
Required

## Analysis
Decidable, System

## Applies to
C90, C99, C11

## Amplification
A *typedef* name shall be unique across all name spaces and translation units. Multiple declarations of the same *typedef* name are only permitted by this rule if the type definition is made in a *header file* and that *header file* is included in multiple source files.

## Rationale
Reusing a *typedef* name either as another *typedef* name or as the name of a function, object or enumeration constant, may lead to developer confusion.

## Exception
The *typedef* name may be the same as the structure, union or enumeration tag name associated with the *typedef*.

## Example
```c
void func ( void )
{
  {
    typedef unsigned char u8_t;
  }
  {
    typedef unsigned char u8_t;   /* Non-compliant - reuse */
  }
}

typedef float mass;

void func1 ( void )
{
  float mass = 0.0f;              /* Non-compliant - reuse */
}

typedef struct list
{
  struct list *next;
  uint16_t     element;
} list;                           /* Compliant - exception */

typedef struct
{
  struct chain
  {
    struct chain *list;
    uint16_t      element;
  } s1;
  uint16_t length;
} chain;                          /* Non-compliant - tag "chain" not
                                   * associated with typedef */
```

## See also
Rule 5.7

---

Copyright The MISRA Consortium Limited © [Date - March 2025].