# Rule 6.1 Bit-fields shall only be declared with an appropriate type

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
The appropriate bit-field types are:
*   C90: either *unsigned int* or *signed int*;
*   C99 and later: one of:
    *   either *unsigned int* or *signed int*;
    *   another explicitly signed or explicitly unsigned integer type that is permitted by the implementation;
    *   *_Bool*.

Note: It is permitted to use *typedefs* to designate an appropriate type.

## Rationale
Using *int* is implementation-defined because bit-fields of type *int* can be either *signed* or *unsigned*.

The use of *enum*, *short*, *char* or any other type for bit-fields is not permitted in C90 because the behaviour is undefined.

In C99 and later, the implementation may define other integer types that are permitted in bit-field declarations.

## Example
The following example is applicable to implementations that do not provide any additional bit-field types. It assumes that the *int* type is 16-bit.

```c
typedef unsigned int UINT_16;

struct s {
  unsigned int b1:2;  /* Compliant                                       */
  int          b2:2;  /* Non-compliant - plain int not permitted         */
  UINT_16      b3:2;  /* Compliant - typedef designating unsigned int    */
  signed long  b4:2;  /* Non-compliant even if long and int are the
                       * same size                                       */
};
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].