# Rule 8.8 The static storage class specifier shall be used in all declarations of objects and functions that have internal linkage

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
Since definitions are also declarations, this rule applies equally to definitions.

## Rationale
The C Standard states that if an object or function is declared with the *extern* storage class specifier and another declaration of the object or function is already visible, the linkage is that specified by the earlier declaration. This can be confusing because it might be expected that the *extern* storage class specifier creates external linkage. The *static* storage class specifier shall therefore be consistently applied to objects and functions with internal linkage.

## Example
```c
static int32_t x = 0;   /* definition: internal linkage */
extern int32_t x;       /* Non-compliant */

static int32_t f ( void );  /* declaration: internal linkage */
int32_t f ( void )          /* Non-compliant */
{
  return 1;
}

static int32_t g ( void );  /* declaration: internal linkage */
extern int32_t g ( void )   /* Non-compliant */
{
  return 1;
}
```

## See also
Rule 1.5

---

Copyright The MISRA Consortium Limited © [Date - March 2025].