# Dir 4.13 Functions which are designed to provide operations on a resource should be called in an appropriate sequence

## Category
Advisory

## Applies to
C90, C99, C11

## Amplification
A set of functions providing operations on a resource typically has three kinds of operation:
1.  Allocation of the resource, e.g. opening a file;
2.  Deallocation of the resource, e.g. closing a file;
3.  Other operations, e.g. reading from a file.

For each such set of functions, all uses of its operations should occur in an appropriate sequence.

## Rationale
Static analyser tools are capable of providing path analysis checks that can identify paths through a program that result in the deallocation function of a sequence not being called. In order to maximize the benefits of such automated checks, developers are therefore encouraged to enable these checks by designing and declaring sets of balanced functions to the static analyser.

## Example
```c
/* These functions are intended to be paired */
extern mutex_t mutex_lock   ( void );
extern void    mutex_unlock ( mutex_t m );

extern int16_t x;

void f ( void )
{
  mutex_t m = mutex_lock ( );

  if ( x > 0 )
  {
    mutex_unlock ( m );
  }
  else
  {
    /* Mutex not unlocked on this path */
  }
}
```

## See also
Rule 22.1, Rule 22.2, Rule 22.6

---

Copyright The MISRA Consortium Limited © [Date - March 2025].