# Rule 0–1–6 (Required) A project shall not contain instances of non-volatile variables being given values that are never subsequently used.

## Rationale
Technically known as a DU dataflow anomaly, this is a process whereby a variable is given a value that is subsequently never used. At best this is inefficient, but may indicate a genuine problem. Often the presence of these constructs is due to the wrong choice of statement aggregates such as loops.

## Exception
Loop control variables (see Section 6.6.5) are exempt from this rule.

## Example
```c
int16_t critical ( int16_t i, int16_t j ) 
{ 
 int16_t result = 0; 
 int16_t k = ( 3 * i ) + ( j * j );
 // Should k be checked here? 
 if ( f2 ( ) ) 
 { 
 // k will only be tested here if f2 returns true 
 // Initialization of k could be moved here 
 if ( k > 0 ) 
 { 
 throw ( 42 ); 
 } 
 }
 // Non-compliant – value of k not used if f2 ( ) returns false 
 return ( result ); 
}
void unusedvalue ( int16_t arr[ 20 ] ) 
{ 
 int16_t j;
 j = 2; 
 for ( int16_t i = 1; i < 10; i++ ) 
 { 
 arr[ i ] = arr[ j ]; 
 j++; // Non-compliant – the value assigned to j 
 } // on the final loop is never used. 
}
void nounusedvalue ( int16_t arr[ 20 ] ) 
{ 
 for ( int16_t i = 1; i < 10; i++ ) 
 { 
 arr[ i ] = arr[ i + 2 ]; 
 } 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
