# Rule 0–4–2 (Document) Use of floating-point arithmetic shall be documented.

## Rationale
The safe use of floating-point arithmetic requires a high level of numerical analysis skills and in-depth knowledge of the compiler and target hardware.
If floating-point is to be used, then the following issues need to be covered as part of the deviation process:
* A justification explaining why floating-point is the appropriate or only solution.
* Demonstrate that appropriate skills are available.
* Demonstrate that an appropriate process is being applied.
* Document the floating-point implementation.

The paper “What Every Computer Scientist Should Know about Floating-Point Arithmetic” [13] explains the issues that need to be considered when using floating-point.

## Example
When solving a quadratic equation, the value of b^2 – 4.a.c is calculated. Assume that a=1.22, b=3.34, c=2.28 and that three significant digits are used during calculation. The exact value of b^2 – 4.a.c is 0.0292. However, b^2 rounds to 11.2 and 4.a.c rounds to 11.1, giving a final answer of 0.1. This example demonstrates catastrophic cancellation. The subtraction does not cause an error, but it does expose errors introduced in the multiplications that are used when generating its operands.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
