# Rule 14–5–3 (Required) A copy assignment operator shall be declared when there is a template assignment operator with a parameter that is a generic parameter.

## Rationale
Contrary to possible developer expectations, a template assignment operator will not suppress the compiler generated copy assignment operator. This may lead to incorrect copy semantics for members requiring deep copies.

## Example
```c
class A 
{ 
public: 
 // A & operator= ( A const & rhs ) Example 1 - implicitly generated 
 // { 
 // i = rhs.i; 
 // return *this; 
 // }
 template <typename T> 
 T & operator= ( T const & rhs ) // Example 2 
 { 
 if ( this != &rhs ) { 
 delete i; 
 i = new int32_t; 
 *i = *rhs.i; 
 } 
 return *this; 
 }
private: 
 int32_t * i; // Member requires deep copy 
};
void f ( A const & a1, A & a2 ) 
{ 
 a2 = a1; // Unexpectedly uses Example 1 
}
```
The implicitly generated copy assignment operator Example 1 will be used to copy a1 to a2.
Therefore, a shallow copy on the pointer member i will result in both a1.i and a2.i pointing to the same object. Was this the intent, or was it expected that a new object would be created and initialized?

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
