# Rule 15–4–1 (Required) If a function is declared with an exception-specification, then all declarations of the same function (in other translation units) shall be declared with the same set of type-ids.

## Amplification
[NDR 15.4(2)]

## Rationale
It is undefined behaviour if a function has different exception-specifications in different translation units.

## Example
```c
// Translation unit A 
void foo( ) throw ( const char_t * ) 
{ 
 throw "Hello World!"; 
}
// Translation unit B 
// foo declared in this translation unit with a different exception 
// specification 
extern void foo ( ) throw ( int32_t ); // Non-compliant - 
 // different specifier
void b ( ) throw ( int32_t ) 
{ 
 foo ( ); // The behaviour here is undefined. 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
