# Rule 15–5–2 (Required) Where a function’s declaration includes an exception-specification, the function shall only be capable of throwing exceptions of the indicated type(s).

## Amplification
[Implementation 15.5.1(2)]

## Rationale
If a function declared with an exception-specification throws an exception of a type not included in the specification, the function unexpected() is called. The behaviour of this function can be overridden within a project, but by default causes an exception of std::bad_exception to be thrown. If std::bad_exception is not listed in the exception-specification, then terminate() will be called, leading to implementation-defined termination of the program.

## Example
```c
// foo does not have an exception specification, so can propagate 
// exceptions of any type, including int 
void foo ( ) 
{ 
 throw ( 21 ); 
}
// goo specifies that it will only throw exceptions of type Exception. 
// If foo throws an int the function unexpected() is called, which may 
// terminate the program 
void goo ( ) throw ( Exception ) 
{ 
 foo ( ); // Non-compliant – int is not listed in the 
 // throw specification 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
