# Rule 5–0–19 (Required) The declaration of objects shall contain no more than two levels of pointer indirection.

## Rationale
Use of more than two levels of indirection can seriously impair the ability to understand the behaviour of the code, and therefore should be avoided.

## Example
```c
typedef int8_t * INTPTR;
struct s { 
 int8_t * s1; // Compliant 
 int8_t ** s2; // Compliant 
 int8_t *** s3; // Non-compliant 
};
struct s * ps1; // Compliant 
struct s ** ps2; // Compliant 
struct s *** ps3; // Non-compliant
int8_t ** ( *pfunc1)(); // Compliant 
int8_t ** ( **pfunc2)(); // Compliant 
int8_t ** (***pfunc3)(); // Non-compliant 
int8_t *** ( **pfunc4)(); // Non-compliant
void function( int8_t * par1, // Compliant 
 int8_t ** par2, // Compliant 
 int8_t *** par3, // Non-compliant 
 INTPTR * par4, // Compliant 
 INTPTR * const * const par5, // Non-compliant 
 int8_t * par6[], // Compliant 
 int8_t ** par7[]) // Non-compliant 
{
 int8_t * ptr1; // Compliant 
 int8_t ** ptr2; // Compliant 
 int8_t *** ptr3; // Non-compliant 
 INTPTR * ptr4; // Compliant 
 INTPTR * const * const ptr5; // Non-compliant 
 int8_t * ptr6[ 10 ]; // Compliant 
 int8_t ** ptr7[ 10 ]; // Compliant 
}
```
Explanation of types
* par1 and ptr1 are of type pointer to int8_t.
* par2 and ptr2 are of type pointer to pointer to int8_t.
* par3 and ptr3 are of type pointer to a pointer to a pointer to int8_t. This is three levels and is non-compliant.
* par4 and ptr4 are expanded to a type of pointer to a pointer to int8_t.
* par5 and ptr5 are expanded to a type of const pointer to a const pointer to a pointer to int8_t. This is three levels and is non-compliant.
* par6 is of type pointer to pointer to int8_t because arrays are converted to a pointer to the initial element of the array.
* ptr6 is of type pointer to array of int8_t.
* par7 is of type pointer to pointer to pointer to int8_t because arrays are converted to a pointer to the initial element of the array. This is three levels and is non-compliant.
* ptr7 is of type array of pointer to pointer to int8_t. This is compliant.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
