# Rule 6–3–1 (Required) The statement forming the body of a switch, while, do ... while or for statement shall be a compound statement.

## Rationale
If the bodies of these statements are not compound statements, then errors can occur if a developer fails to add the required braces when attempting to change a single statement body to a multi-statement body.
Requiring that the body of a switch statement or a while, do ... while or for loop shall be a compound statement (enclosed within braces) ensures that these errors cannot arise.

## Example
```c
for ( i = 0; i < N_ELEMENTS; ++i ) 
{ // Compliant 
 buffer [ i ] = 0; // Even a single statement must 
 // be in braces 
}
for ( i = 0; i < N_ELEMENTS; ++i ); // Non-compliant 
 // Accidental single null statement 
{ 
 buffer [ i ] = 0; 
}
while ( new_data_available ) // Non-compliant 
 process_data ( ); // Incorrectly not enclosed in braces 
 service_watchdog ( ); // Added later but, despite the appearance 
 // (from the indent) it is actually not 
 // part of the body of the while statement, 
 // and is executed only after the loop has 
 // terminated
```
Note that this example assumes a particular style for the layout of compound statements and their enclosing braces. This style is not mandated, but a style should be defined within the style guide for the project.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
