# Rule 6–4–2 (Required) All if … else if constructs shall be terminated with an else clause.

## Rationale
When an if statement is followed by one or more else if statements then the final else if shall be followed by an else statement. In the case of a simple if statement the else statement need not be included.
The final else statement, which should either take appropriate action or contain a suitable comment as to why no action is taken, is defensive programming.

## Example
For example this code is a simple if statement:
```c
if ( x < 0 ) 
{ 
 log_error( 3 ); 
 x = 0; 
} 
// else not needed
```
Whereas the following code demonstrates an if, else if construct
```c
if ( x < 0 ) 
{ 
 log_error ( 3 ); 
 x = 0; 
} 
else if ( y < 0 ) 
{ 
 x = 3; 
} 
else // this else clause is required, even if the 
{ // developer expects this will never be reached 
 // No change in value of x 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
