# Rule 6–4–3 (Required) A switch statement shall be a well-formed switch statement.

## Amplification
A well-formed switch statement conforms to the following syntax rules, which are additional to the C++ standard syntax rules. All syntax rules not defined below are as defined in ISO/IEC 14882:2003 [1].
```
switch-statement:
switch ( condition ) { case-label-clause-list default-label-clauseopt }
case-label-clause-list:
case-label case-clauseopt
case-label-clause-list case-label case-clauseopt
case-label:
case constant-expression :
case-clause:
case-block-seqopt break ;
case-block-seqopt throw assignment-expressionopt ;
{ statement-seqopt break ; }
{ statement-seqopt throw assignment-expressionopt ; }
default-label-clause:
default-label default-clause
default-label:
default :
default-clause:
case-clause
case-block:
expression_statement
compound_statement
selection_statement
iteration_statement
try_block
case-block-seq:
case-block
case-block-seq case-block
```
The following statements, which are permitted by C++, are explicitly not included within the MISRA C++ switch syntax rules. Note, however, that they are permitted within the compound statements forming the body of a switch-clause.
```
labelled_statement
jump_statement
declaration_statement
```
The following terms are also used within the text of the rules:
switch-label Either a case-label or default-label.
case-clause The code between any two switch-labels.
default-clause The code between the default-label and the end of the switch statement.
switch-clause Either a case-clause or a default-clause.

## Rationale
The syntax for the switch statement in C++ is weak, allowing complex, unstructured behaviour. The previous text describes the syntax for switch statements as defined by MISRA C++. This, and the associated rules, imposes a simple and consistent structure on to the switch statement.

## Example
```c
switch ( x ) 
{ 
case 0: 
 ... 
 break; // break is required here 
case 1: // empty clause, break not required 
case 2: 
 break; // break is required here 
default: // default clause is required 
 break; // break is required here, in case a future 
 // modification turns this into a case clause 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
