# Rule 6–5–5 (Required) A loop-control-variable other than the loop-counter shall not be modified within condition or expression.

## Rationale
loop-control-variables are either the loop-counter, or flags used for early loop termination. The code is easier to understand if these are not modified within condition or expression.
Note that it is possible for a loop-control-variable with volatile qualification to change value (or have it changed) outside statement due to the volatile nature of the object. Such modification does not break this rule.

## Example
```c
for ( x = 0; ( x < 10 ) && !bool_a; ++x ) 
{ 
 if ( ... ) 
 { 
 bool_a = true; // Compliant 
 } 
}
bool test_a ( bool * pB ) 
{ 
 *pB = ... ? true : false; 
 return *pB; 
}
for ( x = 0; 
 ( x < 10 ) && test_a ( &bool_a ); 
 ++x ) // Non-compliant
volatile bool status;
for ( x = 0; ( x < 10 ) && status; ++x) // Compliant
for ( x = 0; x < 10; bool_a = test( ++x ) ) // Non-compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
