# Rule 6–5–6 (Required) A loop-control-variable other than the loop-counter which is modified in statement shall have type bool.

## Rationale
loop-control-variables are typically used to terminate a for loop early. The code is easier to understand if this is done with the use of Boolean values (flags).

## Example
```c
for ( x = 0; ( x < 10 ) && ( u8a != 3U ); ++x ) // Non-compliant 
{ 
 uint8_a = fn ( ); 
}
for ( x = 0; ( x < 10 ) && flag; ++x ) // Compliant 
{ 
 u8a = fn ( ); 
 flag = u8a != 3U; 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
