# Rule 6–6–3 (Required) The continue statement shall only be used within a well-formed for loop.

## Rationale
Over-use of the continue statement can lead to unnecessary complexity within the code. This complexity may impede effective testing as extra logic must be tested. The required testing may not be achievable due to control flow dependencies.
A well-formed for loop is one which satisfies Rule 6–5–1 to Rule 6–5–6.

## Example
```c
void fn ( ) 
{ 
 for ( int32_t i = 0 ; i != 10; ++i ) 
 { 
 if ( ( i % 2 ) == 0 ) 
 { 
 continue; // Compliant 
 } 
 // ... 
 }
 int32_t j = -1; 
 for ( int32_t i = 0 ; i != 10 && j != i; ++i ) 
 { 
 if ( ( i % 2 ) == 0 ) 
 { 
 continue; // Non-compliant – loop is not well-formed 
 } 
 // ...
 ++j; 
 } 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
