# Rule 7–1–2 (Required) A pointer or reference parameter in a function shall be declared as pointer to const or reference to const if the corresponding object is not modified.

## Rationale
This rule leads to greater precision in the definition of the function interface. The const qualification shall be applied to the object pointed to, not to the pointer, since it is the object itself that is being protected.

## Exception
This rule does not apply if the parameter object is modified by any of the functions in a set of overriding functions.

## Example
```c
void myfunc( int16_t * param1, 
 const int16_t * param2, 
 int16_t * param3, 
 int16_t * const param4) 
// param1: Addresses an object which is modified - Compliant 
// param2: Addresses an object which is not modified – Compliant 
// param3: Addresses an object which is not modified – Non-compliant 
// param4: Addresses an object which is not modified – Non-compliant 
{ 
 *param1 = *param2 + *param3 + *param4; 
 // Data at address param3 and param4 have not been changed 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
