# Rule 7–5–2 (Required) The address of an object with automatic storage shall not be assigned to another object that may persist after the first object has ceased to exist.

## Rationale
If the address of an automatic object is assigned to another automatic object of larger scope, or to a static object, or returned from a function, then the object containing the address may exist beyond the time when the original object ceases to exist (and its address becomes invalid).
Note that throwing a pointer to an object with automatic storage is also a violation of this rule.

## Example
```c
void foobar ( void ) 
{ 
 int8_t * p1;
 { 
 int8_t local_auto;
 p1 = &local_auto; // Non-compliant 
 } 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
