# Rule 8–5–1 (Required) All variables shall have a defined value before they are used.

## Amplification
[Indeterminate 8.5(9)]

## Rationale
The intent of this rule is that all variables shall have been written to before they are read. This does not necessarily require initialization at declaration.
Note that according to ISO/IEC 14882:2003 [1], variables with static storage duration are automatically initialized to zero by default, unless explicitly initialized. In practice, many embedded environments do not implement this behaviour. Static storage duration is a property of all variables declared with the static storage class specifier, or with external linkage. Variables with automatic storage duration are not usually automatically initialized.
Each class constructor shall initialize all non-static members of its class.

## Example
```c
class C 
{
 public: 
 C ( ) : m_a( 10 ), m_b( 7 ) // Compliant 
 { 
 }
 C ( int32_t a ) : m_a( a ) // Non-compliant 
 { 
 }
 int32_t GetmB ( void ) 
 { 
 return ( m_b ); 
 }
 private: 
 int32_t m_a; 
 int32_t m_b; 
};
C c( 5 );
int main ( void ) 
{ 
 if ( c.GetmB( ) > 0 ) // m_b has not been initialized 
 { 
 } 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
