# Rule 0.1.2 The value returned by a function shall be *used*

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule only applies when the function is called explicitly using *function call* syntax.

## Rationale
It is possible to call a function without *using* the return value, which may be an error. If the return value
of a function is intended to be explicitly discarded, it should be cast to `void` to ensure that it is *used*.

Overloaded operators are excluded from this requirement, as they should behave in the same way as
built-in operators.

Note: this rule effectively requires all non-`void` functions to be treated as if they were declared
`[[nodiscard]]`.

## Example
```cpp
uint16_t func();

void discarded()
{
  func(); // Non-compliant - implicitly discarded
  ( void )func(); // Compliant - void cast is a use
  auto b = func(); // Compliant - used as initializer
}

void f1( std::string q )
{
  std::string s { q } ; // Rule does not apply - not function call syntax
  s = q; // Rule does not apply - not function call syntax
  s.operator=( q ); // Non-compliant
}

void f2( std::function< int() > & f )
{
  f(); // Non-compliant - using function call syntax

  auto a = []() { return 10; };
  a(); // Non-compliant - using function call syntax
}
```

## See also
Rule 28.6.4

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
