# Rule 13.1.1 Classes should not be inherited virtually

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Rationale
Virtual inheritance of base classes is not recommended as it introduces a number of potentially
confusing behaviours, such as call by dominance in diamond hierarchies and changes to the order of
initialization of bases.

## Example
```cpp
struct A
{
 virtual int32_t foo() { return 1; }
};

struct B : public virtual A // Non-compliant
{
 int32_t goo()
 {
 return foo();
 }
};

struct C : public virtual A // Non-compliant
{
 int32_t foo() override { return 2; }
};

struct D : C, B
{
};

int main()
{
 D d;
 return d.goo(); // Calls C::foo(), which may not be expected
}
```

## See also
Rule 8.2.1, Rule 13.1.2, Rule 15.1.1

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
