# Rule 18.1.1 An exception object shall not have pointer type

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Rationale
If an exception object of pointer type is thrown and that pointer refers to a dynamically created object,
then it may be unclear which function is responsible for destroying it, and when. This ambiguity does
not exist if the object is thrown by value.

## Example
```cpp
class A
{
 // Implementation
};

void fn( int16_t i )
{
 static A a1;
 A * a2 = new A;

 if ( i > 10 )
 {
 throw &a1; // Non-compliant - pointer type thrown
 }
 else
 {
 throw a2; // Non-compliant - pointer type thrown
 }
}
```

## See also
Rule 18.3.2

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
