# Rule 19.3.3 The argument to a mixed-use macro parameter shall not be subject to further expansion

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
A *mixed-use macro parameter* is a macro parameter that is used both:
*   As an operand to `#` or `##`; and
*   Not as an operand to these operators.

This rule prohibits invoking a macro with a *mixed-use macro parameter* when the corresponding macro
argument is itself subject to further macro replacement.

## Rationale
A macro parameter that is used as an operand of a `#` or `##` operator is not expanded prior to being
used, whilst the same parameter appearing elsewhere in the replacement text is expanded. This
causes a macro to exhibit different behavior depending on whether or not its arguments are subject
to macro replacement.

## Example
In the macro `SCALE`, `X` is a *mixed-use macro parameter*.

```cpp
#define SCALE( X ) ( ( X ) * X ## _scale )

int32_t speed;
int32_t speed_scale;

int32_t scaled_speed = SCALE( speed ); // Compliant - speed not expanded
 // SCALE expands to
// ( ( speed ) * speed_scale )

#define AA BB
int32_t AA_scale = 1;
int32_t BB = 42;
int32_t BB_scale = 2;

int32_t scaled_AA = SCALE( AA ); // Non-compliant - AA is expanded further
 // SCALE expands to ( (BB) * AA_scale )
// User might expect ( (BB) * BB_scale )
```

The rule does not apply to expansions of the following macro as the parameter `Y` is not a *mixed-use
macro parameter*.

```cpp
#define CC( Y ) ( var1 ## Y + var2 ## Y )
```

## See also
Rule 19.3.1, Rule 19.3.2

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
