# Rule 4.1.1 A program shall conform to ISO/IEC 14882:2017 (C++17)

## Category
Required

## Analysis
Undecidable, System

## Amplification
A conforming program shall be *well-formed*, meaning that it shall be constructed according to the
syntax rules, diagnosable semantic rules, and the *one-definition rule*, as specified for C++17 within
ISO/IEC 14882:2017 [8]. In addition, the program shall use only those features of the C++ language
and its library that are specified within the C++ Standard.

The use of language extensions is not permitted by this rule.

Note: a conforming implementation usually generates a diagnostic if a program is not *well-formed*, but
be aware that:
*   The C++ Standard does not require a diagnostic for all constructs that are not *well-formed*;
*   A diagnostic need not necessarily be an error but could, for example, be a warning;
*   The program may be translated and an executable generated, even if the program is not *well-
    formed*.

## Rationale
Undesirable behaviours associated with language features that are extensions or which are specified
outside of the C++ Standard have not been considered during the development of the guidelines within
this document.

The behaviour of a program that is not *well-formed* is unpredictable.

It is recognized that it is sometimes necessary to use language extensions in embedded systems. If
an extension is used (subject to a deviation), then appropriate steps shall be taken to guarantee
predictable behaviour. This may be documented in a deviation permit to aid reuse, as explained in
MISRA Compliance [1].

## Example
```cpp
#warning "declaring an interrupt handler" // Non-compliant
__interrupt void handler(); // Non-compliant
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
