# Rule 5.13.6 An *integer-literal* of type `long long` shall not use a single `L` or `l` in any suffix

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule applies to both signed `long long` and unsigned `long long` literals.

Note: this rule does not apply to *user-defined-literals*.

## Rationale
A literal with a suffix that has a single `L` could be a `signed` or `unsigned long long`. Use of the `LL`
suffix for `long long` literals is more explicit and less error-prone.

## Example
All of the following examples assume that `long` is 32-bits and `long long` is 64-bits.
```cpp
auto k1 = 12345678998L; // Non-compliant
auto k2 = 12345678998UL; // Non-compliant
auto k3 = 12345678998ull; // Compliant
auto k4 = 0xfeeddeadbeefL; // Non-compliant
auto k5 = 0xfeeddeadbeefLL; // Compliant
```
The rule does not apply to the following as the value is not `long long`:
```cpp
auto k6 = 12345L;
auto k7 = 12345UL;
auto k8 = 0x0badc0deL;
```
The rule does not apply to the following as they do not have `L` or `l` suffixes:
```cpp
auto k9 = 12345678998;
auto kA = 12345678998U;
```

## See also
Rule 5.13.5

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
