# Rule 8.2.11 An argument passed via ellipsis shall have an appropriate type

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
The following types are not appropriate:
1.  `class` types with virtual member functions;
2.  `class` types having non-trivial copy or move operations;
3.  `class` types having a non-trivial destructor.

This rule does not apply to unevaluated contexts.

## Rationale
Passing arguments of some `class` types via an ellipses parameter is only *conditionally-supported* with
*implementation-defined behaviour*.

Default argument promotions are applied to ellipsis parameters, which may lead to the type that is
passed to the function differing from the type that would be passed to a normal function parameter
or when passed as a parameter pack.

Note: passing arguments to a parameter pack is not passing via ellipsis.

## Example
```cpp
struct A
{
  int i { 42 };
  virtual ~A() = default;
};

void f()
{
  std::printf ( "hello %d", A{} ); // Non-compliant
}
```
The following example uses overload resolution and type deduction; it does not pass an argument
via ellipsis at run-time:
```cpp
struct two { char x[2]; };

two test( int );
char test( ... );

template< typename T >
constexpr bool isIntCompatible( T x )
{
  if constexpr ( sizeof( test( x ) ) == 1 ) // Compliant - unevaluated context
  {
    return false; // Overload resolution -> test( ... )
  }
  else
  {
    return true; // Overload resolution -> test( int )
  }
}
```

## See also
Rule 21.10.1

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
