# Dir 5.7.2 Sections of code should not be “commented out”

## Category
Advisory

## Amplification
This directive applies to the use of both `//` and `/* ... */` style comments.

For the purposes of this directive, the use of `#if 0` is also considered to be “commenting out”.

## Rationale
Comments should only be used to explain aspects of the source code; they should not be used to
record the history of changes to the source code.

In addition, whilst the nesting of C-style comments is not supported by the C++ Standard, it is
supported by some compilers. This means that the commenting out of any code that contains
comments may behave differently with different compilers (see Rule 5.7.1).

This directive is generally undecidable, as it is not always possible for a tool to determine if a comment
contains explanatory text, a code example or commented out code.

Note: it is acknowledged that it may be useful to quote statements or expressions as part of a larger
comment in order to document and explain some aspect of the program (e.g. clarifying the use of a
function, or explaining the algorithm being implemented). Such usage is not the intended target of
this directive.

## Example
The following compliant example documents an API with the use of pseudo-code. It is assumed that
code wrapped within the \`\`\` markup is recognized as documentation and is not commented out
code.
```cpp
// You should not call lock/unlock directly, but through RAII:
// ```
// void f( Data & d, MyMutex & m )
// {
//   std::scoped_lock lock { m };
//   d.doSomething();
// } // m is automatically unlocked
// ```

struct MyMutex
{
  void lock();
  void unlock();
};

// The following non-compliant example uses a comment to record code history.

// Bug 42 - this call used to be:
// calculate ( z , y + 1 );
calculate ( x , y - 1 );

enum E
{
#if 0 // Non-compliant
  E_0 // - this is considered to be commented out code
#else
  E_1
#endif
};
```

## See also
Rule 5.7.1

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
