Classes decorated with @Component must have suffix "Component" (or custom) in their name. See more at https://angular.io/styleguide#style-02-03

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: 'sg-foo-bar'
})
class Test {}
      ~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: 'sgBarFoo'
})
class TestPage {}
      ~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: 'sgBarFoo'
})
class TestPage {}
      ~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: 'sgBarFoo'
})
class TestDirective {}
      ~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'sg-foo-bar',
  template: '<foo-bar [foo]="bar">{{baz + 42}}</foo-bar>'
})
class TestComponent {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: '[myHighlight]'
})
class TestDirective {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({
  selector: 'sg-test-pipe'
})
class TestPipe {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable()
class TestService {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
class TestEmpty {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'sgBarFoo'
})
class TestPage {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'sgBarFoo'
})
class TestPage {}
```

</details>
