<h2>Why is this an issue?</h2>
<p>Assigning a value to a <code>static</code> field in a constructor could cause unreliable behavior at runtime since it will change the value for all
instances of the class.</p>
<p>Instead remove the field’s <code>static</code> modifier, or initialize it statically.</p>
<h3>Noncompliant code example</h3>
<pre>
public class Person
{
  private static DateTime dateOfBirth;
  private static int expectedFingers;

  public Person(DateTime birthday)
  {
    dateOfBirth = birthday;  // Noncompliant; now everyone has this birthday
    expectedFingers = 10;  // Noncompliant
  }
}
</pre>
<h3>Compliant solution</h3>
<pre>
public class Person
{
  private DateTime dateOfBirth;
  private static int expectedFingers = 10;

  public Person(DateTime birthday)
  {
    this.dateOfBirth = birthday;
  }
}
</pre>

